﻿/*********************************************************************************
// This code is created by SimCoder Version 12.0.1 for F2837x Hardware Target
//
// SimCoder is copyright by Powersim Inc., 2009-2019
//
// Date: October 31, 2019 13:49:48
**********************************************************************************/
#include	<math.h>
#include	"PS_bios.h"
#define	GetCurTime() PS_GetSysTimer()
#define	PWM_IN_CHECK	// To lower PWM value setting time, comment out this line if PWM duty cycle values are strictly limited in the range.





interrupt void Task();
#include "SFO_V8.h"
int MEP_ScaleFactor = 0;

#ifdef _FLASH
#pragma DATA_SECTION(PSK_SysClk, "copysections")
#endif
const Uint16 PSK_SysClk = 200;  // MHz







interrupt void Task()
{
	DefaultType	fVDC2, fVDC1;

	PSM_PwmIntrEntry(1);

	fVDC1 = 0.3;
	fVDC2 = 90;
	// Start of changing PWM2(phase shift) registers
	// Set Duty Cycle
	{
		static Uint16 oldTBPHS2 = 0;
		Uint16 reg, _cmpA;
		DefaultType _val;
		_val  = __fsat(fVDC1, 1 + 0, 0);
		_val = ((Uint32)(PWM_TBPRD(2))+1) * ((1 + 0) - _val) * (1.0 / 1);
		PWM_CMPA(2) = _cmpA = (int)_val;
		PWM_CMPAHR(2) = (int)((_val - _cmpA) * MEP_ScaleFactor + 1.5) << 8;
		_val = __fracf32(fVDC2 * (1.0/360.0) + 64.0);
		reg = (int)(((Uint32)(PWM_TBPRD(2))+1) * (2.0 - _val));
		if ((_cmpA > oldTBPHS2) && (_cmpA <= reg)) {
			_cmpA = reg;	// We add this because TBPHS doesn't have shadow register.
							// this causes problem sometimes.
		}
		PWM_TBPHS(2) = oldTBPHS2 = reg;
		PWM_CMPA(2) = _cmpA;
	}
	// End of changing PWM2(phase shift) registers
	// Start of changing PWM1(1ph) registers
	// Set Duty Cycle
	{
		DefaultType _val = __fsat(fVDC1, 1 + 0, 0);
		_val = ((Uint32)(PWM_TBPRD(1))+1) * (((1 + 0) - _val) * (1.0 / 1));
		PWM_CMPA(1) = (int)_val;
		PWM_CMPAHR(1) = (int)((_val - (int)_val) * MEP_ScaleFactor + 1.5) << 8;
	}
	// End of changing PWM1(1ph) registers
}

// Calibrate High resolution PWM at the beginning
void HRPwmCalibration()
{
	while (1) {
		switch (SFO()) {
		case SFO_INCOMPLETE:
			break;
		case SFO_COMPLETE:
			return;
		case SFO_ERROR:
			asm(" ESTOP0");
			break;
		}
	}
}


void Initialize(void)
{
	PS_SysInit(2, 20);
    HRPwmCalibration();
	PS_PwmStartStopClock(-1);	// Stop Pwm Clock
	PS_TimerInit(0, 0);
	PS_PwmInit(1, 0, 0, 1.e6/(10000*1.0), ePwmUseAB, ePwmStartLow1, ePwmComplement, HRPWM_NOCALIB);	// pwmNo, pinSel, waveType, period, outtype, PwmA, PWMB, UseHRPwm
	PS_PwmSetDeadBand(1, 0, 2, 3, 0, 1, 1);
	PS_PwmSetIntrType(1, ePwmNoAdc, 1, 0);
	PS_PwmSetIntrVector(1, Task);
	PS_PwmSetTripAction(1, eTzHiZ, eTzHiZ);
	PWM_CMPA(1) = (1 + 0 - 0) / (1.0 * 1) * PWM_TBPRD(1);
	PSM_PwmStart(1);

	PS_PwmInit(2, 0, 0, 1.e6/(10000*1.0), ePwmUseAB, ePwmStartLow1, ePwmComplement, HRPWM_NOCALIB);	    // pwmNo, pinSel, wave type, period, outtype, PwmA, PWMB, UseHRPwm
	PS_PwmSetDeadBand(2, 0, 2, 3, 0, 1, 1);
	PS_PwmSetPhaseDelay(2, 1, 0);
	PS_PwmSetIntrType(2, ePwmNoAdc, 1, 0);
	PS_PwmSetTripAction(2, eTzHiZ, eTzHiZ);
	PWM_CMPA(2) = (1 + 0 - 0) / (1.0 * 1) * PWM_TBPRD(2);
	PSM_PwmStart(2);

	PS_PwmStartStopClock(1);	// Start Pwm Clock
}


void main()
{
	Initialize();
	PSM_EnableIntr();   // Enable Global interrupt INTM
	PSM_EnableDbgm();
	for (;;) {
	}
}

